//------------------------------------
//  (c) 1998 Reliable Software
//------------------------------------
#include "about.h"

AboutDialog::AboutDialog(HINSTANCE appInstance, LPCSTR templateName, HWND parent)
{
	DialogBox (appInstance, templateName, parent, DLGPROC(AboutDlgProc));
}

static void CenterWindow(HWND hwnd);

BOOL CALLBACK AboutDialog::AboutDlgProc (HWND hwnd, UINT message, UINT wParam, LPARAM lParam)
{
    switch (message)
    {
    case WM_INITDIALOG:
		CenterWindow(hwnd);
        return TRUE;
    case WM_COMMAND:
        switch (LOWORD(wParam))
        {
        case IDOK:
        case IDCANCEL:
            EndDialog(hwnd, 0);
            return TRUE;
        }
        break;
    }
    return FALSE;
}

void CenterWindow(HWND hwnd)
{
    // Center the window of the desktop if it has no parent
    RECT    ownerBounds;
    {
        HWND    hwndOwner = GetParent(hwnd);
        if (hwndOwner == NULL) 
            hwndOwner = GetDesktopWindow(); 
        GetWindowRect(hwndOwner, &ownerBounds); 
    }

    RECT	dialogBounds;
    // Place the dialog at 0,0
    GetWindowRect(hwnd, &dialogBounds);
    OffsetRect(&dialogBounds, -dialogBounds.left, -dialogBounds.top);

    // set the dialog position centered
    {
        int diffWidth   = ownerBounds.right - ownerBounds.left - dialogBounds.right,
            diffHeight  = ownerBounds.bottom - ownerBounds.top - dialogBounds.bottom;

        OffsetRect(&dialogBounds, ownerBounds.left + diffWidth/2, ownerBounds.top + diffHeight/2);
    }

    SetWindowPos(hwnd, 
        HWND_TOP, 
        dialogBounds.left,
        dialogBounds.top,
        0, 0,
        SWP_NOSIZE); 
}