//------------------------------------
//  (c) 1998 Reliable Software
//------------------------------------
#include "canvas.h"

void Canvas::Oval(RECT const & r, PenDescription const & pd, BOOL createCircle)
{
   Pen         pen(pd);
   PenHolder   holder(_hdc, pen);
   StockObject nullBrush(_hdc, NULL_BRUSH); // do not fill the stencil

   ::MoveToEx (_hdc, r.left, r.top, 0);

   if (createCircle)
   {
      int width     = r.right - r.left;
      int height    = r.bottom - r.top;
      int size      = max(width, height);
      Ellipse(_hdc, r.left, r.top, r.left + size, r.top + size);
   }
   else
      Ellipse(_hdc, r.left, r.top, r.right, r.bottom);
}

void Canvas::Rect (RECT const & r, PenDescription const & pd)
{
   Pen         pen(pd);
   PenHolder   holder(_hdc, pen);
   StockObject nullBrush(_hdc, NULL_BRUSH); // do not fill the stencil

   ::MoveToEx (_hdc, r.left, r.top, 0);

   Rectangle(_hdc, r.left, r.top, r.right, r.bottom);
}

void Canvas::Line ( POINT p1, POINT p2, PenDescription const & pd)
{
   Pen         pen(pd);
   PenHolder   holder(_hdc, pen);

   MoveToEx (_hdc, p1.x, p1.y, 0);
   LineTo (_hdc, p2.x, p2.y);
}

void Canvas::ThinOval    (RECT const & r, BOOL createCircle)
{
    PenDescription pd;
    Oval(r, pd, createCircle);
}

void Canvas::ThinRect    (RECT const & r)
{
    PenDescription pd;
    Rect(r, pd);
}

void Canvas::ThinLine    (POINT p1, POINT p2)
{
    PenDescription pd;
    Line(p1, p2, pd);
}
