//------------------------------------
//  (c) 1998 Reliable Software
//------------------------------------
#ifndef _CANVAS_H_INCLUDED
#define _CANVAS_H_INCLUDED

#include <windows.h>
#include <assert.h>
#include "pens.h"

class Canvas
{
public:
    operator HDC () { return _hdc; }

    void Oval    (RECT const & r, PenDescription const & pd, BOOL createCircle = FALSE);
    void Circle  (RECT const & r, PenDescription const & pd){Oval(r, pd, TRUE);}
    void Rect	(RECT const & r, PenDescription const & pd);
	void Line	( POINT p1, POINT p2, PenDescription const & pd);
    void ThinOval    (RECT const & r, BOOL createCircle = FALSE);
    void ThinCircle  (RECT const & r){ ThinOval(r, TRUE); }
    void ThinRect    (RECT const & r);
    void ThinLine    (POINT p1, POINT p2);
protected:
    Canvas (HDC hdc): _hdc (hdc) {}

    HDC  _hdc;
};

// Use for painting after WM_PAINT
class PaintCanvas: public Canvas
{
public:
    PaintCanvas (HWND hwnd)
    : Canvas (BeginPaint (hwnd, &_paint)),
      _hwnd (hwnd)
    {
        assert (_hdc != 0);
    }

    ~PaintCanvas ()
    {
        EndPaint(_hwnd, &_paint);
    }
 
protected:
                 
    PAINTSTRUCT _paint;
    HWND        _hwnd;
};

class UpdateCanvas: public Canvas
{
public:
	UpdateCanvas (HWND hwnd)
	: Canvas(GetDC (hwnd)),
	  _hwnd(hwnd)
	{}
	
	~UpdateCanvas ()
	{
		ReleaseDC (_hwnd, _hdc);
	}
protected:
	HWND	_hwnd;
};

#endif // _CANVAS_H_INCLUDED
