//------------------------------------
//  (c) 1998 Reliable Software
//------------------------------------
#include <windows.h>
#include "control.h"
#include <new.h>

class WinException
{
public:
    WinException (char* msg)
    : _err (GetLastError()), _msg(msg)
    {}
    DWORD GetError() const { return _err; }
    char* GetMessage () const { return _msg; }
private:
    DWORD _err;
    char* _msg;
};

class WindowClass: public WNDCLASSEX
{
public:
    WindowClass (WNDPROC WndProc, char const * className, HINSTANCE hInst)
	{
	    cbSize          = sizeof (WNDCLASSEX);
	    style           = CS_HREDRAW | CS_VREDRAW;
	    lpfnWndProc     = WndProc;
	    cbClsExtra      = 0;
	    cbWndExtra      = 0;
	    hInstance       = hInst;
	    hIcon           = 0;
	    hIconSm         = 0;
	    hCursor         = LoadCursor (0, IDC_ARROW);
	    hbrBackground   = (HBRUSH) (COLOR_WINDOW + 1);
	    lpszMenuName    = className;
	    lpszClassName   = className;
	}
    void Register ()
    {
        if (RegisterClassEx (this) == 0)
            throw WinException ("RegisterClassEx");
    }
};

// Window (needed by Windows)
class Window
{
public:
    Window (): _hwnd(0) {}
    Window ( char const * caption, char const * className, HINSTANCE hInstance )
	{
	    _hwnd = CreateWindow (
	        className,
	        caption,
	        WS_OVERLAPPEDWINDOW,
	        CW_USEDEFAULT,
	        CW_USEDEFAULT,
	        CW_USEDEFAULT,
	        CW_USEDEFAULT,
	        NULL,
	        NULL,
	        hInstance,
	        NULL );
	    if (_hwnd == 0)
	        throw "Window Creation Failed";
	}
    void Show ( int nCmdShow )
    {
        ::ShowWindow ( _hwnd, nCmdShow );
        ::UpdateWindow ( _hwnd );
    }
    operator HWND() { return _hwnd; }
protected:
    HWND _hwnd;
};

// procedures called by Windows
LRESULT CALLBACK WndProc ( HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam );

// out of memory handler that throws WinException
int NewHandler (size_t size);

static BOOL
SetupIcons(HWND hwnd, LPCSTR resource, HINSTANCE hinst);

int PASCAL
WinMain (HINSTANCE hInst, HINSTANCE hPrevInst, char * cmdParam, int cmdShow)
{
    char className [] = "DrawApp";
    _set_new_handler (&NewHandler);

    BOOL isError = FALSE;
    try
    {
        WindowClass winClass (WndProc, className, hInst);
        winClass.Register ();

        Window win (className, className, hInst);
        win.Show ( cmdShow );
    }
    catch ( WinException e )
    {
        char buf [50];
        wsprintf ( buf, "%s, Error %d", e.GetMessage (), e.GetError () );
        MessageBox (0, buf, "Exception", MB_ICONEXCLAMATION | MB_OK);
        isError = TRUE;
    }
    catch (...)
    {
        MessageBox (0, "Unknown", "Exception", MB_ICONEXCLAMATION | MB_OK);
        isError = TRUE;
    }

    if (isError)
        return 0;

    // The main message loop
    MSG  msg;
    int status;
    while ((status = GetMessage (&msg, 0, 0, 0)) != 0)
    {
        if (status == -1)
            return -1;
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }
    return msg.wParam;
}            

int NewHandler (size_t size)
{
    throw WinException ( "Out of memory" );
    return 0;
}

// Window Proc
LRESULT CALLBACK
WndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    static Controller * pCtrl;
    
    switch (message)
    {
    case WM_CREATE:
		SetupIcons(hwnd, "DRAWAPP", ((CREATESTRUCT *)lParam)->hInstance);
        try
        {
            pCtrl = new Controller (hwnd, (CREATESTRUCT *) lParam);
        }
        catch (WinException e)
        {
            MessageBox (hwnd, e.GetMessage(), "Initialization", MB_ICONEXCLAMATION | MB_OK);
            return -1;
        }
        catch (...)
        {
            MessageBox (hwnd, "Unknown Error", "Initialization", MB_ICONEXCLAMATION | MB_OK);
            return -1;
        }
        return 0;
    case WM_SIZE:
        pCtrl->Size(LOWORD(lParam), HIWORD(lParam));
        return 0;
    case WM_PAINT:
        pCtrl->Paint(hwnd);
        return 0;
    case WM_COMMAND:
        pCtrl->Command(hwnd, LOWORD (wParam));
        return 0;
    case WM_LBUTTONDOWN:
        pCtrl->ShapeBegin(MAKEPOINTS(lParam));
        return 0;
    case WM_MOUSEMOVE:
        if (wParam & MK_LBUTTON)
            pCtrl->ShapeMove(MAKEPOINTS(lParam));
        return 0;
    case WM_LBUTTONUP:
        pCtrl->ShapeEnd(MAKEPOINTS(lParam));
        return 0;
    case WM_DESTROY:
        delete pCtrl;
        return 0;
    }
    return DefWindowProc (hwnd, message, wParam, lParam);
}

static BOOL
SetupIcons(HWND hwnd, LPCSTR resource, HINSTANCE hinst)
{
	HICON hIconSm = (HICON)LoadImage(
		hinst,
		resource,
		IMAGE_ICON,
		GetSystemMetrics (SM_CXSMICON),
		GetSystemMetrics (SM_CYSMICON),
		LR_DEFAULTCOLOR
	);

	HICON hIcon = (HICON)LoadImage(
		hinst,
		resource,
		IMAGE_ICON,
		GetSystemMetrics (SM_CXICON),
		GetSystemMetrics (SM_CYICON),
		LR_DEFAULTCOLOR
	);

    SendMessage (hwnd, WM_SETICON, WPARAM (TRUE), LPARAM (hIcon));
    SendMessage (hwnd, WM_SETICON, WPARAM (FALSE), LPARAM (hIconSm));
	return TRUE;
}
