//------------------------------------
//  (c) 1998 Reliable Software
//------------------------------------
#ifndef _menu_H_INCLUDED
#define _menu_H_INCLUDED

#include <windows.h>
#include "resource.h"

class MenuItem
{
public:
    MenuItem(HMENU menu, UINT itemID)
    : _menu(menu), _itemID(itemID)
    {
    }
    void Disable()  { ::EnableMenuItem  (_menu, _itemID, MF_GRAYED);   }
    void Enable()   { ::EnableMenuItem  (_menu, _itemID, MF_ENABLED);  }
    void Check()    { ::CheckMenuItem   (_menu, _itemID, MF_CHECKED);  }
    void UnCheck()  { ::CheckMenuItem   (_menu, _itemID, MF_UNCHECKED);}
protected:
    HMENU   _menu;
    UINT    _itemID;
};

class SubMenu
{
public:
    SubMenu(HMENU parent, UINT position)
    :	_parent(parent),
        _position(position)
    {}
    void Enable()   { ::EnableMenuItem(_parent, _position, MF_ENABLED   | MF_BYPOSITION);}
    void Disable()  { ::EnableMenuItem(_parent, _position, MF_GRAYED    | MF_BYPOSITION);}
protected:
    HMENU _parent;
    UINT  _position;
};

class ToolMenu : public SubMenu
{
public:
    ToolMenu(HMENU menu, int position)
    :	SubMenu     (menu, position),
        _line       (menu, IDM_LINE),
        _ellipse    (menu, IDM_ELLIPSE),
        _circle		(menu, IDM_CIRCLE),
        _rect       (menu, IDM_RECTANGLE)
    {
        _line.Check();
    }
    void SelectLineTool()       { UnCheckAll(); _line.Check();   }
    void SelectEllipseTool()    { UnCheckAll(); _ellipse.Check();}
    void SelectCircleTool()     { UnCheckAll(); _circle.Check(); }
    void SelectRectTool()       { UnCheckAll(); _rect.Check();   }
private:
    void UnCheckAll()
    {
        _line.UnCheck();
        _ellipse.UnCheck();
        _circle.UnCheck();
        _rect.UnCheck();
    }
    MenuItem    _line,
                _ellipse,
                _circle,
                _rect;
};

class ColorMenu : public SubMenu
{
public:
    ColorMenu(HMENU menu, int position)
    :   SubMenu (menu, position),
        _black  (menu, IDM_BLACK),
        _red    (menu, IDM_RED),
        _green  (menu, IDM_GREEN),
        _blue   (menu, IDM_BLUE)
    {
        _black.Check();
    }
    void SelectBlackColor() { UnCheckAll(); _black.Check(); }
    void SelectRedColor()   { UnCheckAll(); _red.Check();   }
    void SelectGreenColor() { UnCheckAll(); _green.Check(); }
    void SelectBlueColor()  { UnCheckAll(); _blue.Check();  }
private:
    void UnCheckAll()
    {
        _black.UnCheck();
        _red.UnCheck();
        _green.UnCheck();
        _blue.UnCheck();
    }

    MenuItem    _black,
                _red,
                _green,
                _blue;
};

class StyleMenu : public SubMenu
{
public:
    StyleMenu(HMENU menu, int position)
    :	SubMenu     (menu, position),
        _solid      (menu, IDM_SOLID),
        _dot        (menu, IDM_DOT),
        _dash       (menu, IDM_DASH),
        _dashdot    (menu, IDM_DASHDOT),
        _dashdotdot (menu, IDM_DASHDOTDOT)
    {
        _solid.Check();
    }
    void SelectSolidStyle()     { UnCheckAll(); _solid.Check();     }
    void SelectDotStyle()       { UnCheckAll(); _dot.Check();       }
    void SelectDashStyle()      { UnCheckAll(); _dash.Check();      }
    void SelectDashDotStyle()   { UnCheckAll(); _dashdot.Check();   }
    void SelectDashDotDotStyle(){ UnCheckAll(); _dashdotdot.Check();}
private:
    void UnCheckAll()
    {
        _solid.UnCheck();
        _dash.UnCheck();
        _dot.UnCheck();
        _dashdot.UnCheck();
        _dashdotdot.UnCheck();
    }

    MenuItem    _solid,
                _dash,
                _dot,
                _dashdot,
                _dashdotdot;
};

class WidthMenu : public SubMenu
{
public:
    WidthMenu(HMENU menu, int position)
    :	SubMenu (menu, position),
        _one    (menu, IDM_PEN_WIDTH_1),
        _two    (menu, IDM_PEN_WIDTH_2),
        _three  (menu, IDM_PEN_WIDTH_3),
        _four   (menu, IDM_PEN_WIDTH_4),
        _five   (menu, IDM_PEN_WIDTH_5)
    {
        _one.Check();
    }
    void SelectWidth1()	{ UnCheckAll(); _one.Check();   }
    void SelectWidth2()	{ UnCheckAll(); _two.Check();   }
    void SelectWidth3()	{ UnCheckAll(); _three.Check(); }
    void SelectWidth4()	{ UnCheckAll(); _four.Check();  }
    void SelectWidth5()	{ UnCheckAll(); _five.Check();  }
private:
    void UnCheckAll()
    {
        _one.UnCheck();
        _two.UnCheck();
        _three.UnCheck();
        _four.UnCheck();
        _five.UnCheck();
    }

    MenuItem    _one,
                _two,
                _three,
                _four,
                _five;
};

#endif // _menu_H_INCLUDED
