//------------------------------------
//  (c) 1998 Reliable Software
//------------------------------------
#include "control.h"
#include "canvas.h"
#include "shape.h"
#include "about.h"

Controller::Controller (HWND hwnd, CREATESTRUCT * pCreate)
    :   _hInst  (pCreate->hInstance),
        _hwnd   (hwnd),
        _tools  (pCreate->hMenu, IDM_TOOLS),
        _colors (pCreate->hMenu, IDM_COLORS),
        _styles (pCreate->hMenu, IDM_STYLES),
        _widths (pCreate->hMenu, IDM_WIDTHS)
{
}

Controller::~Controller()
{
    PostQuitMessage(0);
}

void Controller::Paint (HWND hwnd)
{
    PaintCanvas canvasScreen (hwnd);
    _view.Paint (canvasScreen, _model.GetShapes ());
}

void Controller::ShapeBegin(POINTS pos)
{
	// Capture the mouse to control the entire drawing process
	SetCapture(_hwnd);
	_model.CreateNewShape(pos);
}

void Controller::ShapeMove(POINTS pos)
{
	// ignore this call if the current mouse capture owner is not this
	if (GetCapture() != _hwnd)
		return;

    _model.SetEndPosition(pos);
    UpdateCanvas canvasScreen (_hwnd);
    _view.Update (canvasScreen, _model.GetShapes ());
}

void Controller::ShapeEnd(POINTS pos)
{
	// ignore this call if the current mouse capture owner is not this
	if (GetCapture() != _hwnd)
		return;

    _model.SetEndPosition(pos);
    UpdateCanvas canvasScreen (_hwnd);
    _view.FinalUpdate (canvasScreen, _model.GetShapes ());

	// Not drawing anymore; release the mouse
	ReleaseCapture();
}

// Menu commands processing
void Controller::Command (HWND hwnd, int cmd)
{
    switch (cmd)
    {
    case IDM_NEW:
        _model.Clear();
        _view.Clear();
        ::InvalidateRect(hwnd, 0, TRUE);
        break;
    case IDM_LINE:
        _model.SetShapeType(SHAPE_LINE);
        _tools.SelectLineTool();
        break;
    case IDM_RECTANGLE:
        _model.SetShapeType(SHAPE_RECT);
        _tools.SelectRectTool();
        break;
    case IDM_ELLIPSE:
        _model.SetShapeType(SHAPE_ELLIPSE);
        _tools.SelectEllipseTool();
        break;
    case IDM_CIRCLE:
        _model.SetShapeType(SHAPE_CIRCLE);
        _tools.SelectCircleTool();
        break;
    case IDM_BLACK:
        _model.SetColor(BLACK_COLOR);
        _colors.SelectBlackColor();
      break;
    case IDM_GREEN:
        _model.SetColor(GREEN_COLOR);
        _colors.SelectGreenColor();
        break;
    case IDM_BLUE:
        _model.SetColor(BLUE_COLOR);
        _colors.SelectBlueColor();
        break;
    case IDM_RED:
        _model.SetColor(RED_COLOR);
        _colors.SelectRedColor();
      break;
    case IDM_SOLID:
        _model.SetStyle(PS_SOLID);
        _styles.SelectSolidStyle();
        break;
    case IDM_DASH:
        _model.SetStyle(PS_DASH);
        _styles.SelectDashStyle();
        break;
    case IDM_DOT:
        _model.SetStyle(PS_DOT);
        _styles.SelectDotStyle();
        break;
    case IDM_DASHDOT:
        _model.SetStyle(PS_DASHDOT);
        _styles.SelectDashDotStyle();
        break;
    case IDM_DASHDOTDOT:
        _model.SetStyle(PS_DASHDOTDOT);
        _styles.SelectDashDotStyle();
        break;
    case IDM_PEN_WIDTH_1:
        _model.SetPenWidth(1);
        _widths.SelectWidth1();
        ControlStylesMenu(TRUE);
        break;
    case IDM_PEN_WIDTH_2:
        _model.SetPenWidth(2);
        _widths.SelectWidth2();
        ControlStylesMenu(FALSE);
        break;
    case IDM_PEN_WIDTH_3:
        _model.SetPenWidth(3);
        _widths.SelectWidth3();
        ControlStylesMenu(FALSE);
        break;
    case IDM_PEN_WIDTH_4:
        _model.SetPenWidth(4);
        _widths.SelectWidth4();
        ControlStylesMenu(FALSE);
        break;
    case IDM_PEN_WIDTH_5:
        _model.SetPenWidth(5);
        _widths.SelectWidth5();
        ControlStylesMenu(FALSE);
        break;

    case IDM_EXIT:
        SendMessage (hwnd, WM_CLOSE, 0, 0L);
        break;
    case IDM_HELPHELP:
        MessageBox (_hwnd, "Go figure!", "DrawApp", MB_ICONINFORMATION | MB_OK);
        break;
    case IDM_ABOUT:
        {
			AboutDialog about(_hInst, "About", _hwnd);
		}
        break;
    }
}

void Controller::ControlStylesMenu(BOOL newState)
{
    if (newState)
        _styles.Enable();
    else
        _styles.Disable();

    ::DrawMenuBar(_hwnd);
}
