//------------------------------------
//  (c) 1998 Reliable Software
//------------------------------------
#ifndef _SHAPE_H_INCLUDED
#define _SHAPE_H_INCLUDED

#include <windows.h>
#include "canvas.h"

class Point : public POINT
{
public:
	Point( unsigned int val = 0)
	{
		x = LOWORD(val);
		y = HIWORD(val);
	}
	Point( POINTS val)
	{
		x = val.x;
		y = val.y;
	}
	operator POINTS () {return *this;}
	Point & operator = (POINT & p) 
	{
		x = p.x; 
		y = p.y; 
		return *this;
	}
};

enum SHAPE_TYPE
{
	SHAPE_RECT,
	SHAPE_LINE,
	SHAPE_ELLIPSE,
	SHAPE_CIRCLE
};

class Shape
{
public:
	Shape(PenDescription & pd, SHAPE_TYPE vo = SHAPE_LINE, Point origin = 0);

	void SetEndPosition     (int x = 0, int y = 0);
	void SetColor           (COLORREF color){ _pd.SetColor(color);}

	virtual void Draw (Canvas & canvas, BOOL finalDraw = FALSE) const = 0;
    virtual void DrawPrevious(Canvas & canvas) const = 0;
protected:
    PenDescription  _pd;
	SHAPE_TYPE      _type;
    POINT           _previousEndPos;

    RECT            _boundary;
};

class RectShape : public Shape
{
public:
	RectShape(PenDescription & pd, Point startPos)
	: Shape(pd, SHAPE_RECT, startPos)
	{}
	void Draw(Canvas & canvas, BOOL finalDraw = FALSE) const;
    void DrawPrevious(Canvas & canvas) const;
};

class LineShape : public Shape
{
public:
	LineShape(PenDescription & pd, Point startPos)
	: Shape(pd, SHAPE_LINE, startPos)
	{}
	void Draw(Canvas & canvas, BOOL finalDraw = FALSE) const;
    void DrawPrevious(Canvas & canvas) const;
};

class CircleShape : public Shape
{
public:
	CircleShape(PenDescription & pd, Point startPos)
	: Shape(pd, SHAPE_CIRCLE, startPos)
	{}
	void Draw(Canvas & canvas, BOOL finalDraw = FALSE) const;
    void DrawPrevious(Canvas & canvas) const;
};

class EllipseShape : public Shape
{
public:
	EllipseShape(PenDescription & pd, Point startPos)
	: Shape(pd, SHAPE_ELLIPSE,startPos)
	{}
	void Draw(Canvas & canvas, BOOL finalDraw = FALSE) const;
    void DrawPrevious(Canvas & canvas) const;
};

class ShapeStore
{
public:
	ShapeStore(int initialSize = 8)
	: _capacity(0), _count(0), _data(0)
	{
		Grow(initialSize);
	}
	~ShapeStore()
	{
		EmptyOut();
	}
	int GetSize () const {return _count;}
	int EmptyOut ();
	int Append(SHAPE_TYPE type, PenDescription & pd, POINTS startPos);
	Shape & GetLast()
	{
		return (*(_data[_count - 1]));
	}
	void Draw       (Canvas & canvas) const;
    void DrawUpdate (Canvas & canvas) const;
    void DrawLast   (Canvas & canvas) const;
protected:
	void    Grow(int minimumCapacity = 8);
	Shape	**	_data;
	int		_count;
	int		_capacity;
};

#endif // _SHAPE_H_INCLUDED