#if !defined (WINMAKER_H)
#define WINMAKER_H
//
// (c) Reliable Software, 1997
//

#include "Win.h"
#include "WinString.h"

class WinMaker
{
public:
    WinMaker (int idClassName, HINSTANCE hInstance);
    WinMaker (char const * className, HINSTANCE hInstance);
    operator HWND () { return _hwnd; }
    void SetPosition (int x, int y, int width, int height);
	void AddCaption (char const * caption)
	{
		_windowName = caption;
	}
	void AddSysMenu () { _style |= WS_SYSMENU; }
    void AddVScrollBar () { _style |= WS_VSCROLL; }
    void AddHScrollBar () { _style |= WS_HSCROLL; }
	void AddDlgBorder () { _style |= WS_DLGFRAME; }
	void AddBorder () { _style |= WS_BORDER; }
	void AddTitleBar () { _style |= WS_CAPTION; }
    void Create ();
    void Show (int nCmdShow = SW_SHOWNORMAL);
protected:

    ResString   _classString;
    HWnd        _hwnd;

    DWORD       _exStyle;       // extended window style
    char const *_className;     // pointer to registered class name
    char const *_windowName;    // pointer to window name
    DWORD       _style;         // window style
    int         _x;             // horizontal position of window
    int         _y;             // vertical position of window
    int         _width;         // window width  
    int         _height;        // window height
    HWnd        _hWndParent;    // handle to parent or owner window
    HMENU       _hMenu;         // handle to menu, or child-window identifier
    HINSTANCE   _hInstance;     // handle to application instance
    void *      _data;          // pointer to window-creation data
};

class TopWinMaker: public WinMaker
{
public:
    TopWinMaker (char const * caption, int idClassName, HINSTANCE hInst);
};

class ChildWinMaker: public WinMaker
{
public:
    ChildWinMaker (int idClassName, HWnd hwndParent, int childId);
    ChildWinMaker (char const * className, HWnd hwndParent, int childId);
};

class PopupWinMaker: public WinMaker
{
public:
    PopupWinMaker (int idClassName, HINSTANCE hInst);
};

// Getting and Setting WindowLong: default is GWL_USERDATA

template <class T>
inline T GetWinLong (HWND hwnd, int which = GWL_USERDATA)
{
    return reinterpret_cast<T> (::GetWindowLong (hwnd, which));
}

template <class T>
inline void SetWinLong (HWND hwnd, T value, int which = GWL_USERDATA)
{
    ::SetWindowLong (hwnd, which, reinterpret_cast<long> (value));
}

#endif
