//----------------------------------------
// (c) Reliable Software 1997
//----------------------------------------
#ifndef _CONTROLS_H_INCLUDED
#define _CONTROLS_H_INCLUDED

#include <windows.h>
#include "resource.h"

class SimpleControl
{
public:
    SimpleControl (HWND hwndParent, int id, bool initialState=true)
        : _hWnd (GetDlgItem (hwndParent, id))
    {
        if (initialState == false)
            Disable();
    }
    void Hide ()
    {
        ::ShowWindow(_hWnd , SW_HIDE);
    }
    void Show ()
    {
        ::ShowWindow(_hWnd , SW_SHOW);
    }
    bool IsVisible()
    {
        return(::IsWindowVisible(_hWnd ) != 0);
    }
    void SetFocus ()
    {
        ::SetFocus (_hWnd);
    }
    void Enable()
    {
        ::EnableWindow(_hWnd , TRUE);
    }
    void Disable()
    {
        ::EnableWindow(_hWnd , FALSE);
    }
    HWND Hwnd () const { return _hWnd; }
    void Update()
    {
        ::UpdateWindow(_hWnd);
    }

protected:
    HWND _hWnd;
};

class Button : public SimpleControl
{
public:
   Button(HWND hwndParent, int id, bool initialState=true)
       : SimpleControl(hwndParent, id, initialState)
   {}
   void SetName( char const * newName )
   {
      SendMessage(_hWnd, WM_SETTEXT, 0, (LPARAM)newName );
   }
};

class Edit: public SimpleControl
{
public:
   Edit (HWND hwndParent, int id, bool initialState=true)
        :	SimpleControl (hwndParent, id, initialState)
   {}

   void SetString (char const * buf)
   {
       SendMessage (_hWnd, WM_SETTEXT, 0, (LPARAM) buf);
   }

   void Clear ()
   {
       SendMessage (_hWnd, WM_SETTEXT, 0, (LPARAM) "");
       Update();
   }

   // code is the HIWORD (wParam)
   static bool IsChanged (int code)
   {
       return code == EN_CHANGE;
   }

   int GetLength ()
   {
       return (int)(SendMessage (_hWnd, WM_GETTEXTLENGTH, 0, 0));
   }

   void GetString (char* buf, int len)
   {
       SendMessage (_hWnd, WM_GETTEXT, (WPARAM) len, (LPARAM) buf);
   }

   void Select ()
   {
       SendMessage (_hWnd, EM_SETSEL, 0, -1);
   }

   void ClearSelection ()
   {
       SendMessage (_hWnd, EM_SETSEL, (WPARAM)-1, 0);
   }
};

#endif // _CONTROLS_H_INCLUDED
