//----------------------------------------
// (c) Reliable Software 1997
//----------------------------------------
#include <new.h>
#include "main.h"
#include "resource.h"
#include "controller.h"

int NewHandler (size_t size)
{
    throw WinException ( "Out of memory" );
    return 0;
}

static void ErrorBox(char const *message, char const *caption);
static BOOL SetWindowIcons(HWND hwnd, UINT resourceID);

BOOL CALLBACK DialogProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    static Controller* control = 0;
    switch (message)
    {
    case WM_INITDIALOG:
        try
        {
            control = new Controller (hwnd);
        }
        catch (WinException e)
        {
            ErrorBox (e.GetMessage (), "Exception");
        }
        catch (...)
        {
            ErrorBox ("Unknown", "Exception");
            return -1;
        }
		if (!SetWindowIcons(hwnd, TREESIZER_ICON))
			ErrorBox("LoadIcons failed.","May be a problem");
		CenterWindow(hwnd);
        return TRUE;
    case WM_COMMAND:
        control->Command(hwnd, LOWORD(wParam), HIWORD (wParam));
        return TRUE;
    case WM_DESTROY:
        PostQuitMessage(0);
        return TRUE;
    case WM_CLOSE:
        delete control;
        DestroyWindow (hwnd);
        return TRUE;
    }
    return FALSE;
}

int WINAPI WinMain
   (HINSTANCE hInst, HINSTANCE hPrevInst, char * cmdParam, int cmdShow)
{
    _set_new_handler (&NewHandler);

    HWND hDialog = CreateDialog (hInst, MAKEINTRESOURCE (DIALOG_MAIN), 0, (DLGPROC)DialogProc);
    if (!hDialog)
    {
        char buf [100];
        wsprintf (buf, "Error x%x", GetLastError ());
        ErrorBox (buf, "CreateDialog");
        return 1;
    }

    MSG  msg;
    int status;
    while ((status = GetMessage (&msg, 0, 0, 0)) != 0)
    {
        if (status == -1)
            return -1;
        if (!IsDialogMessage (hDialog, &msg))
        {
            TranslateMessage ( &msg );
            DispatchMessage ( &msg );
        }
    }

    return msg.wParam;
}

HINSTANCE
GetHinstance (HWND hwnd)
{
	return ((HINSTANCE) ::GetWindowLong(hwnd, GWL_HINSTANCE));
}

void
CenterWindow(HWND hwnd)
{
    // Center the window on the desktop if it has no parent
    HWND hwndOwner = GetParent(hwnd);
    if (hwndOwner == NULL) 
        hwndOwner = GetDesktopWindow(); 

    RECT ownerBounds;
    GetWindowRect(hwndOwner, &ownerBounds); 

    // Place the dialog at 0,0
    RECT dialogBounds;
    GetWindowRect(hwnd, &dialogBounds);
    OffsetRect(&dialogBounds, -dialogBounds.left, -dialogBounds.top);

    // set the dialog position centered
    int diffWidth   = ownerBounds.right - ownerBounds.left - dialogBounds.right;
    int diffHeight  = ownerBounds.bottom - ownerBounds.top - dialogBounds.bottom;

    OffsetRect(&dialogBounds, ownerBounds.left + diffWidth/2, ownerBounds.top + diffHeight/2);

    SetWindowPos(hwnd, 
        HWND_TOP, 
        dialogBounds.left,
        dialogBounds.top,
        0, 0,
        SWP_NOSIZE); 
}

static BOOL
SetWindowIcons(HWND hwnd, UINT resourceID)
{
	HINSTANCE hInst = GetHinstance(hwnd);
    HICON hIcon = LoadIcon (hInst, MAKEINTRESOURCE (resourceID));
    HICON hIconSm = (HICON)LoadImage (
        hInst,
        MAKEINTRESOURCE (resourceID),
        IMAGE_ICON,
        GetSystemMetrics (SM_CXSMICON),
        GetSystemMetrics (SM_CYSMICON),
        LR_SHARED);

	if (hIcon && hIconSm)
	{
	    // Attach the icons
	    SendMessage (hwnd, WM_SETICON, WPARAM (TRUE), LPARAM (hIcon));
	    SendMessage (hwnd, WM_SETICON, WPARAM (FALSE), LPARAM (hIcon));
		return TRUE;
	}
	else
		return FALSE;
}

static void ErrorBox(char const *message, char const *caption)
{
	::MessageBox (0,message, caption, MB_ICONEXCLAMATION | MB_OK);
}
