//----------------------------------------
// (c) Reliable Software 1997
//----------------------------------------
#ifndef _path_H_INCLUDED
#define _path_H_INCLUDED

#include "main.h"
#include <stdlib.h>
#include <string.h>

class Path
{
public:
	Path(char const * name)
        :_pathLen (strlen (name))
	{
        if (_pathLen >= MAX_PATH)
            throw WinException ("Path too long");
		strcpy(_name,name);
		if (_name[_pathLen - 1] == '\\')
        {
            _pathLen--;
        }
        SetCurrentDirectory(_name);
	}
	char const * WildcardPath()
	{
		// create a wildcard path of the name
        if (_pathLen + 4 >= MAX_PATH)
            throw WinException ("Path too long");
		strcpy(_name + _pathLen, "\\*.*");
        return _name;
	}
	void DirDown(char const * name)
	{
        int len = strlen (name);
        if (_pathLen + len + 1 >= MAX_PATH)
            throw WinException ("Path too long");

		strcpy (_name + _pathLen, "\\");
		strcat(_name, name);
        _pathLen += len + 1;
        SetCurrentDirectory(_name);
	}
	void DirUp()
	{
        _name [_pathLen] = '\0';
		// remove the last part of this string
		char * lastSep = strrchr(_name, '\\');
		if (lastSep)
		{
		    *lastSep = '\0';
            _pathLen = lastSep - _name;
            if ((lastSep - _name) == 2)
            {
                // preserve the directory separator when we have reached the root
                _name[2] = '\\';
                _name[3] = '\0';
            }
		}
        SetCurrentDirectory(_name);
	}
	char const * GetName() const {return _name;}
protected:
    int     _pathLen;
	char    _name[MAX_PATH + 1];
};

#endif // _path_H_INCLUDED
