//----------------------------------------
// (c) Reliable Software 1997
//----------------------------------------
#ifndef _shell95_H_INCLUDED
#define _shell95_H_INCLUDED

#include <windows.h>
#include <shlobj.h>

template <class T>class SIfacePtr
{
public:
    ~SIfacePtr ()
    {
        Free ();
    }
    T * operator->() { return _p; }
    T const * operator->() const { return _p; }
    operator T const * () const { return _p; }
    T const & GetAccess () const { return *_p; }

protected:
    SIfacePtr () : _p (0) {}
    void Free ()
    {
        if (_p != 0)
            _p->Release ();
        _p = 0;
    }

    T * _p;
private:
    SIfacePtr (SIfacePtr const & p) {}
    void operator = (SIfacePtr const & p) {}
};

template <class T>
class SShellPtr
{
public:
    ~SShellPtr ()
    {
        Free ();
        _malloc->Release ();
    }
    //T * weak operator->() { return _p; }
    T const * operator->() const { return _p; }
    operator T const * () const { return _p; }
    T const & GetAccess () const { return *_p; }

protected:
    SShellPtr () : _p (0) 
    {
        // Obtain malloc here, rather than
        // in the destructor. 
        // Destructor must be fail-proof.
        if (SHGetMalloc (&_malloc) == E_FAIL)
            throw "Couldn't obtain Shell Malloc"; 
    }
    void Free ()
    {
        if (_p != 0)
            _malloc->Free (_p);
        _p = 0;
    }

    T * _p;
    IMalloc *  _malloc;
private:
    SShellPtr (SShellPtr const & p) {}
    void operator = (SShellPtr const & p) {}
};

class Desktop: public SIfacePtr<IShellFolder>
{
public:
    Desktop ()
    {
        if (SHGetDesktopFolder (&_p) != NOERROR)
            throw "SHGetDesktopFolder failed";
    }
};

class ShPath: public SShellPtr<ITEMIDLIST>
{
public:
    ShPath (SIfacePtr<IShellFolder> & folder, wchar_t * path = L"")
    {
        ULONG lenParsed = 0;
        _hresult = folder->ParseDisplayName (0, 0, path, &lenParsed, &_p, 0);
    }
    bool IsOK () const { return SUCCEEDED (_hresult); }
private:
    HRESULT _hresult;
};

class FolderBrowser: public SShellPtr<ITEMIDLIST>
{
public:
    FolderBrowser (
        HWND hwndOwner,
        SShellPtr<ITEMIDLIST> & root,
        UINT browseForWhat,
        char const *title);

    char const * GetDisplayName () { return _displayName; }
    char const * GetPath ()        { return _fullPath; }
    bool IsOK() const              { return _p != 0; };

private:
    char       _displayName [MAX_PATH];
    char       _fullPath [MAX_PATH];
    BROWSEINFO _browseInfo;
};

FolderBrowser::FolderBrowser (
    HWND hwndOwner,
    SShellPtr<ITEMIDLIST> & root,
    UINT browseForWhat,
    char const *title)
{
    _displayName [0] = '\0';
    _fullPath [0] = '\0';
    _browseInfo.hwndOwner = hwndOwner;
    _browseInfo.pidlRoot = root; 
    _browseInfo.pszDisplayName = _displayName;
    _browseInfo.lpszTitle = title;
    _browseInfo.ulFlags = browseForWhat; 
    _browseInfo.lpfn = 0;
    _browseInfo.lParam = 0;
    _browseInfo.iImage = 0;
    // Let the user do the browsing
    _p = SHBrowseForFolder (&_browseInfo);
     if (_p != 0)
        SHGetPathFromIDList (_p, _fullPath);
}

#endif // _shell95_H_INCLUDED
