//----------------------------------------
// (c) Reliable Software 1997
//----------------------------------------
#include <windows.h>
#include <iomanip.h>
#include "controls.h"
#include "controller.h"
#include "main.h"
#include "shell95.h"
#include "visitor.h"

Controller::Controller (HWND hwnd)
:	_hwnd			(hwnd),
	_pathField		(hwnd, IDC_PATHNAME),
	_browse			(hwnd, IDC_BROWSE),
	_calculate		(hwnd, IDC_CALCULATE),
	_resultField	(hwnd, IDC_RESULT),
	_exit			(hwnd, IDC_EXIT),
	_clear			(hwnd, IDC_NEW)
{
    _pathField.SetFocus();
	_resultField.SetString("-- No directory selected --");
}

class PathSelector
{
public:
	PathSelector(HWND hwnd)
	{
		_path [0] = '\0';
		Desktop desktop;
		ShPath browseRoot (desktop);
		if (browseRoot.IsOK ())
		{
		    FolderBrowser browser (hwnd,
		                          browseRoot,
		                          BIF_RETURNONLYFSDIRS,
		                          "Select folder to analyze");
		    if (browser.IsOK ())
		    {
		        strcpy (_path, browser.GetPath ());
		    }
		}
	}
	bool IsValid() const {return _path[0] != '\0';}
	char const * GetPath() const {return _path;}
private:
	char _path[MAX_PATH + 1];
};

void Controller::Command (HWND hwnd, int controlID, int command)
{
    switch (controlID)
    {
        case IDC_PATHNAME:
            if (_pathField.IsChanged(command))
            {
                if (_pathField.GetLength())
				{
                    _calculate.Enable();
					_clear.Enable();
                }
                else
				{
                    _calculate.Disable();
					_clear.Disable();
				}
            }
            break;
		case IDC_BROWSE:
            if (command == BN_CLICKED)
			{
				PathSelector	userPath(hwnd);
				if (userPath.IsValid())
                {
                    _pathField.SetString(userPath.GetPath());
                    _resultField.Clear();
				}
			}
			break;
		case IDC_CALCULATE:
            if (command == BN_CLICKED)
			{
                try
                {
				    BeginNewCalculation();

				    // do the real work
                    char path[MAX_PATH + 1];
                    _pathField.GetString(path, MAX_PATH);
					if (path[0] == '.')
					{
						_calculate.Disable();
						MessageBox(hwnd, "TreeSizer does not support relative paths in this version.", "Our problem ...", MB_OK|MB_ICONEXCLAMATION);
					}
					else
					{
	                    ULONG size = CalculateFolderSize(path);

					    // and present the result
					    ostrstream result;
					    CreateResultString(size, result);
					    _resultField.SetString(result.str());
					}
                }
                catch (WinException & e)
                {
                    MessageBox (0, e.GetMessage (), "Exception", MB_ICONEXCLAMATION | MB_OK);
                }
                catch (...)
                {}
                _clear.Enable();
				_calculate.Enable();
            }
			break;
		case IDC_EXIT:
            if (command == BN_CLICKED)
		        SendMessage (hwnd, WM_CLOSE, 0, 0L);
			break;
		case IDC_NEW:
			_pathField.Clear();
			BeginNewCalculation();
			break;
    }
}

class MouseWait
{
public:
	MouseWait()
	{
		_previous = SetCursor(LoadCursor(0, IDC_WAIT));
	}
	~MouseWait()
	{
		if (_previous)
			SetCursor(_previous);
	}
private:
	HCURSOR _previous;
};

ULONG Controller::CalculateFolderSize(char const * folderName)
{
	MouseWait mw;
	Sizer sizer;
	Traversal traversal(folderName, sizer);
	return sizer.GetTotalSize();
}

void Controller::BeginNewCalculation()
{
	_calculate.Disable();
	_resultField.Clear();
    _clear.Disable();
}

void Controller::CreateResultString(ULONG size, ostrstream & ostr)
{
	ostr << size << " bytes";

	if (size > 1024)
	{
	    char *suffixes[] = {"", " KB", " MB", " GB", " TB"};
	    int numSuffixes = 5;
	    int suffix;
	    double realSize = static_cast<double> (size);
	    for (suffix = 0; suffix < numSuffixes; suffix++)
	    {
            if (realSize <= 1024)
                break;
	        realSize /= 1024;
	    }

 		ostr << "  ";
        ostr.precision(3);
        ostr << realSize << suffixes[suffix];
 	}
	ostr << '\0';
}
