//----------------------------------------
// (c) Reliable Software 1997
//----------------------------------------
#ifndef _visitor_H_INCLUDED
#define _visitor_H_INCLUDED

#include <windows.h>
#include "path.h"

class Visitor;

class Traversal
{
public:
    Traversal (Path & path, Visitor & visitor);
    Traversal (char const * directoryName, Visitor & visitor);

private:
    void TraverseTree (Path & path);

private:
    Visitor & _visitor;
};

class Visitor
{
public:
    virtual ~Visitor ()
    {}

    virtual bool Visit (char const * name) { return false; }
};

class Sizer: public Visitor
{
public:
    Sizer ()
        : _totalSize (0)
    {}

    bool Visit (char const * name);
    ULONG GetTotalSize () const { return _totalSize; }

private:
    ULONG _totalSize;
};

#endif // _visitor_H_INCLUDED
