#if !defined MAIN_H
#define MAIN_H
//------------------------------------
//  (c) Reliable Software, 1997
//------------------------------------

#include <windows.h>
#include "winex.h"
#include "resource.h"

// procedures called by Windows

LRESULT CALLBACK WndProc
   ( HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam );

BOOL CALLBACK AboutDlgProc
   ( HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam );

// out of memory handler that throws WinException
int NewHandler (size_t size);

class WindowClass: public WNDCLASSEX
{
public:
    WindowClass (WNDPROC WndProc, char const * className, HINSTANCE hInst);
    void Register ()
    {
        if (RegisterClassEx (this) == 0)
            throw WinException ("RegisterClassEx");
    }
};

// Window (needed by Windows)

class Window
{
public:
    Window (): _hwnd(0) {}
    Window ( char const * caption, char const * className, HINSTANCE hInstance );
    void Show ( int nCmdShow )
    {
        ::ShowWindow ( _hwnd, nCmdShow );
        ::UpdateWindow ( _hwnd );
    }
    operator HWND() { return _hwnd; }
protected:
    HWND _hwnd;
};

#endif

