#if !defined FOLDER_WATCHER_H
#define FOLDER_WATCHER_H
//------------------------------------
//  FolderWatcher.h
//  (c) Reliable Software, 1997
//------------------------------------

#include "Active.h"
#include "winex.h"

class FileChangeEvent
{
public:
    FileChangeEvent (char const * folder, BOOL recursive, DWORD notifyFlags)
    {
        _handle = FindFirstChangeNotification (folder, recursive, notifyFlags);
        if (INVALID_HANDLE_VALUE == _handle)
            throw WinException ("Cannot create change notification handle");
    }
    ~FileChangeEvent ()
    {
        if (INVALID_HANDLE_VALUE != _handle)
            FindCloseChangeNotification (_handle);
    }

    operator HANDLE () const { return _handle; }
    BOOL ContinueNotification ()
    {
        return FindNextChangeNotification (_handle);
    }

private:
    HANDLE _handle;
};

class FolderChangeEvent : public FileChangeEvent
{
public:
    FolderChangeEvent (char const * folder)
        : FileChangeEvent (folder, FALSE, FILE_NOTIFY_CHANGE_FILE_NAME)
    {}
};

class TreeChangeEvent : public FileChangeEvent
{
public:
    TreeChangeEvent (char const * root)
        : FileChangeEvent (root, TRUE, FILE_NOTIFY_CHANGE_FILE_NAME | FILE_NOTIFY_CHANGE_DIR_NAME)
    {}
};

UINT const WM_FOLDER_CHANGE = WM_USER;

class FolderWatcher : public ActiveObject
{
public:
    FolderWatcher (char const * folder, HWND hwnd)
        : _notifySource (folder),
          _hwndNotifySink (hwnd)
    {
        strcpy (_folder, folder);
        _thread.Resume ();
    }
    ~FolderWatcher ()
    {
        Kill ();
    }

private:
    void InitThread () {}
    void Loop ();
    void FlushThread () {}

    FolderChangeEvent _notifySource;
    HWND _hwndNotifySink;
    char _folder [MAX_PATH];
};

#endif
